import random
import matplotlib.pyplot as plt

learning = 'sample'  # The type of learning ('map' or 'sample')
bias = 0.6           # The preference for language 1
noise = 0.2          # The probability of producing the wrong utterance

# Produces an utterance for a particular language
def produce(language):
    if random.random() > noise:
        return language
    else:
        if language == 0:
            return 1
        if language == 1:
            return 0

# Generate a list of n utterances from a language
def generate_data(language, n):
    data_accumulator = []
    for i in range(n):
        utterance = produce(language)
        data_accumulator.append(utterance)
    return data_accumulator


# Gives the prior bias for a particular language. 
def prior(language):
    if language == 1:
        return bias
    else:
        return (1 - bias)



# Calculates P(data | language)
def likelihood(data, language):
    total = 1.
    for utterance in data:
        if  utterance == language:
            total = total * (1. - noise)
        else:
            total = total * noise
    return total




# Picks a language give the posterior probabilities of all languages
# This will either be the maximum a posteriori language ('map')
# or a language sampled from the posterior
def select_language(data):    
    list_of_all_languages = [0,1]
    list_of_posteriors = []
    for language in list_of_all_languages:
        this_language_posterior = likelihood(data,language) * prior(language) 
        list_of_posteriors.append(this_language_posterior)
    if learning == 'map':
        map_language = wta(list_of_posteriors)
        return map_language
    if learning == 'sample':
        sampled_language = roulette_wheel(list_of_posteriors)
        return sampled_language
        

# good old winner-take-all
def wta(items):
    maxweight = max(items)
    candidates = []
    for i in range(len(items)):
        if items[i] == maxweight:
            candidates.append(i)
    return random.choice(candidates)

# Given a list of scores, returns a position in that list selected randomly
# in proportion to its score
def roulette_wheel(scores):
    summed_scores = sum(scores)
    r = random.uniform(0,summed_scores)
    accumulator = 0
    for i in range(len(scores)):
        accumulator += scores[i]
        if r < accumulator:
            return i
    

# Run a single chain for a particular bottleneck.
# Chains are initialised with a random initial language
# Returns final language in chain, plus list detailing cumulative
# proportion of language 1 over time
def simulation(generations, bottleneck, output_every):
    language=random.randint(0,1)
    language1_count = 0.
    data_accumulator = []
    for i in range(1,generations+1):
        print language,
        language1_count+=language
        if output_every != 0:
            if (i % output_every) == 0:
                    data_accumulator.append(language1_count/i)
        data = generate_data(language, bottleneck)
        language = select_language(data)
    return [language,data_accumulator]


# Run a lot of simulations and returns the distribution of final languages
def simulation_batch(generations, bottleneck, number_of_runs):
    data_accumulator = []
    for i in range(number_of_runs):
        final_language=simulation(generations, bottleneck, 0)[0]
        data_accumulator.append(final_language)
    proportion_language1 = sum(data_accumulator)/float(number_of_runs)
    return proportion_language1

